IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_RC_VD_CONV_CARTAO_PEND')
BEGIN
	DROP TRIGGER TRG_RC_VD_CONV_CARTAO_PEND
END

GO

CREATE TRIGGER [dbo].[TRG_RC_VD_CONV_CARTAO_PEND] ON [dbo].[RC_VD_CONV] FOR INSERT, UPDATE AS
BEGIN 
	
	INSERT INTO RC_VD_CONV_CARTAO_PEND (CD_EMP, CD_CTR)
		SELECT 
			DISTINCT 
			I.CD_EMP, 
			I.CD_CTR
		FROM 
			INSERTED I
		WHERE 
			EXISTS (
					SELECT 
						T.CD_EMP
					FROM 
						RC_CLI_CONV_RC_ADM_CARTAO T
					WHERE 
						T.CD_EMP	= I.CD_EMP
						AND T.CD_CONV	= I.CD_CONV)
			AND NOT EXISTS (
					SELECT 
						T.CD_EMP
					FROM 
						RC_VD_CONV_CARTAO_PEND T
					WHERE 
						T.CD_EMP		= I.CD_EMP
						AND T.CD_CTR	= I.CD_CTR)

END
